<?php

    #	SonicCampGuard
    #
    #	Copyright (c) 2024 Bundeswehr
    #	Diese Anwendung wurde von Cedric Prietz entwickelt.
    #	E-Mail: CedricPrietz@bundeswehr.org
    #	App: 90-8303-54618
    #
    #	Letzte Änderung: 23.09.2024

    require_once 'function.inc.php';
    pageName("Mein Konto");
    requireLogin();
    if(!$_SESSION['Type'] == 'local') { header('Location: /dashboard'); }
    include('header.inc.php');

    // Neues Passwort setzen
    if(isset($_POST['changePassword']))
    {
        if($_POST['password'] == $_POST['confirm_password'])
        {
            initializeDatabaseConnection();

            $hashedPassword = password_hash($_POST['password'], PASSWORD_DEFAULT);

            $sql = "UPDATE Accounts SET Password = :password WHERE username = :username";
            $stmt = $pdo->prepare($sql);

            $stmt->bindParam(':password', $hashedPassword);
            $stmt->bindParam(':username', $_SESSION['Username']);

            if ($stmt->execute()) {
                addAuditLog($_SESSION['Username'], 'Profil', 'Neues Passwort festgelegt');

                echo '
                <script>
                    document.addEventListener("DOMContentLoaded", function() {
                        Swal.fire({
                            title: "",
                            text: "Das Passwort wurde erfolgreich geändert!",
                            icon: "success"
                        });
                    });
                </script>';
            }
        }
    }

    // Profil Updaten
    if(isset($_POST['saveProfile']))
    {
        if($_POST['displayName'])
        {
            initializeDatabaseConnection();

            $sql = "UPDATE Accounts SET DisplayName = :displayname WHERE username = :username";
            $stmt = $pdo->prepare($sql);

            $stmt->bindParam(':displayname', $_POST['displayName']);
            $stmt->bindParam(':username', $_SESSION['Username']);

            if ($stmt->execute()) {

                $_SESSION['DisplayName'] = $_POST['displayName'];
                addAuditLog($_SESSION['Username'], 'Profil', 'Benutzerdaten im Profil geändert');

                echo '
                <script>
                    document.addEventListener("DOMContentLoaded", function() {
                        Swal.fire({
                            title: "",
                            text: "Das Profil wurde erfolgreich gespeichert!",
                            icon: "success"
                        });
                    });
                </script>';
            }
        }
    }
?>
<div class="d-flex justify-content-between align-items-center flex-wrap grid-margin">
    <div>
        <h4 class="mb-3 mb-md-0">Mein Konto</h4>
    </div>
</div>
<div class="row">

    <div class="col-lg-12 col-xl-8 grid-margin">
        <div class="card">
        <form action="" method="post"  id="editProfile">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-baseline mb-2">
                        <h6 class="card-title">Benutzerdaten</h6>
                    </div>
                    <div class="mb-3">
                        <label for="current_username" class="form-label">Benutzername</label>
                        <input id="current_username" class="form-control" type="text" value="<?php echo $_SESSION['Username']; ?>" disabled>
                    </div>
                    <div class="mb-3">
                        <label for="current_role" class="form-label">Rolle</label>
                        <input id="current_role" class="form-control" type="text" value="<?php echo $_SESSION['Role']; ?>" disabled>
                    </div>
                    <div class="mb-3">
                        <label for="displayName" class="form-label">Vollständiger Name</label>
                        <input id="displayName" class="form-control" name="displayName" type="text" value="<?php echo $_SESSION['DisplayName']; ?>">
                    </div>

                    <input class="btn btn-primary" type="submit" name="saveProfile" value="Speichern">
                </div>
            </form>
        </div>
    </div>
    <div class="col-lg-12 col-xl-4 grid-margin">
        <div class="card">
            <form action="" method="post"  id="editPassword">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-baseline mb-2">
                        <h6 class="card-title">Passwort</h6>
                    </div>
                    <div class="mb-3">
                        <label for="current_password" class="form-label">Aktuelles Passwort</label>
                        <input id="current_password" class="form-control" name="current_password" type="password">
                    </div>
                    <div class="mb-3">
                        <label for="password" class="form-label">Neues Passwort</label>
                        <input id="password" class="form-control" name="password" type="password">
                    </div>
                    <div class="mb-3">
                        <label for="confirm_password" class="form-label">Passwort bestätigen</label>
                        <input id="confirm_password" class="form-control" name="confirm_password" type="password">
                    </div>

                    <input class="btn btn-primary" type="submit" name="changePassword" value="Ändern">
                </div>
            </form>
        </div>
    </div>

</div>

    


<?php include('footer.inc.php'); ?>